define(['angular',
    'app',
    'authentication_service',
    'moment',
    'PatientFHIRService',
    'FitnessService'],
    function (angular,
              app) {
	'use strict';
	app.controller('LandingController',
        function ($modal,
                  $scope,
                  $parse,
                  $window,
                  globalDelayTracker,
                  focusService,
                  TrackersService,
                  PatientFHIRService,
                  authenticationService ,
                  modalService,
                  $timeout,
                  formatter,
                  HomePageConstants,
                  WeeklyGoalsService,
                  GoalGraphService,
                  FitnessService,
                  FitnessGoalsFHIRService,
                  GoalGraphAccessibilityService,
                  NotificationsPreferencesService,
                  TrackersConstants
    ) {

            $scope.globalDelayTracker = globalDelayTracker;
            $scope.notificationsDataPointers = NotificationsPreferencesService.dataPointers;
            $scope.userName = null;
            $scope.advocateForName = null;
            $scope.facilityName = null;
            $scope.loggedInUser = {};

            $scope.details = {};
            focusService.focusMain();
            $scope.today = new Date();
            $scope.isPhoneView = $window.innerWidth < 768;
            $scope.section = "fitness-goals";
            angular.extend($scope, TrackersConstants["fitness-goals"].entry);
            //angular.extend($scope, HomePageConstants["weekly-goals"].entry);


            if (authenticationService.isAuthenticated()) {
                PatientFHIRService.getPatientContext().then(function(loggedInUser){
                    var userdetails = {};
                    userdetails = loadUserDetails(loggedInUser);

                });
            }

        var goalService = WeeklyGoalsService.instance();

        $scope.openGoalsModal = function () {

            FitnessService.openGoalsModal($scope.details).then(function (details) {
                goalService.save(details).then(function () {
                    setDetails(true);
                });
            }).finally(function () {
                focusService.focusElement(angular.element('button[ng-click="openGoalsModal()"]'));

            });
        };


            $scope.initGraph = function () {
                    thisinit('fn init');

            };


		NotificationsPreferencesService.getNotificationsPreferenceAndCount();

		$scope.today = new Date();

		function thisinit(location) {

		// array to store which slides are active, by default, first slide is active
		// this controller needs access to the active-ness of slides for 508 hiding reasons
		$scope.activeSlides = [true, false, false];


          //  if (!$scope.dashboard) {
                $scope.dashboard = [
                    {
                        id: 'fitness-goals',
                        title: 'Fitness Goals',
                        icon: 'icon-learnmore-fitness',
                        units: 'Weekly Activity Goal',
                        updatedField: 'effectiveDateTime',
                        expression: 'extension[4].valueString',
                        minutes: 'component[0].valueQuantity.value',
                        steps: 'extension[1].valueString',
                        miles: 'component[1].valueQuantity.value',
                        activeFlag: 'component[3].valueString',
                        startDate: 'extension[4].valueString',
                        endDate: 'extension[5].valueString',
                        type: 'target'
                    },
                    {
                        id: 'fitness-activity',
                        title: 'Fitness Activities',
                        icon: 'icon-learnmore-fitness',
                        units: 'Fitness Activity',
                        updatedField: 'effectiveDateTime',
                        minutes: 'component[0].valueQuantity.value',
                        steps: 'extension[1].valueString',
                        miles: 'component[1].valueQuantity.value',
                        type: 'progress',
                        startDate: 'effectiveDateTime'
                    },

                ];

                angular.extend($scope.details, HomePageConstants["weekly-goals"]);

                angular.forEach($scope.dashboard, function (item) {
                    item.service = TrackersService.instance(item.id);


                    if (item.id==="fitness-goals")
                    {
                        item.service.getLatest();
                    }
                    else
                        {
                            item.service.getActLatest();
                        };

                    if ($scope.details && item.type === 'target') {
                        $scope.details.target.minutes = $parse(item.minutes)(item.service.latest);
                        $scope.details.target.steps = parseFloat($parse(item.steps)(item.service.latest));
                        $scope.details.target.miles = $parse(item.miles)(item.service.latest);
                        $scope.details.startDate = $parse(item.startDate)(item.service.latest);
                        $scope.details.endDate = $parse(item.endDate)(item.service.latest);
                        $scope.endDate = $parse(item.endDate)(item.service.latest);
                    }

                    if ($scope.details && item.type === 'progress') {
                        var minutes = 0;
                        var steps = 0;
                        var miles = 0;
                        angular.forEach(item.service.latest, function (index, key) {

                            var thisresult = [];
                            thisresult.push(key);


                        });

                        // Initiated Minutes
                        if ($parse(item.minutes)(item.service.latest) === undefined) {
                            $scope.details.progress.minutes = 0;
                        }
                        else
                        {
                            $scope.details.progress.minutes = $parse(item.minutes)(item.service.latest);
                        }

                        // Initiated Steps
                        if ($parse(item.steps)(item.service.latest) === undefined) {
                            $scope.details.progress.steps = 0;
                        }
                        else
                        {
                            $scope.details.progress.steps = parseFloat($parse(item.steps)(item.service.latest));
                        }
                        // Initiate Miles
                        if ($parse(item.miles)(item.service.latest) === undefined) {
                            $scope.details.progress.miles = 0;
                        }
                        else
                        {
                            $scope.details.progress.miles = $parse(item.miles)(item.service.latest);
                        }
                        }




                });
     //   }


			$scope.xsScreenResolution = function () {
				return $window.innerWidth < 768;
			};
			$scope.goalGraphConfig = GoalGraphService.getGraphConfig($scope.details);
            $scope.screenReaderText = GoalGraphAccessibilityService.getScreenReaderTexts($scope.details);

            $scope.updated = function(item) {
                $scope.$apply();
                return item.service.latest[item.updatedField];
            };
		}




            function setDetails(fetchNew) {

                if (goalService.dataPointers.list.length === 0) {
                    $scope.details = goalService.createEmpty();
                    if (!goalService.promptedSession) {
                        goalService.promptedSession = true;
                        $scope.openGoalsInfoModal();
                        thisinit('setDetails(ogim)');
                    }
                } else {
                    $scope.details = goalService.dataPointers.list[0];

                    angular.extend($scope.details,HomePageConstants["weekly-goals"]);

                    if (fetchNew) {
                        fetchGoals();
                        thisinit('setDetails(fetchNew');
                    }
                }


                $scope.goalGraphConfig = GoalGraphService.getGraphConfig($scope.details);
                $scope.screenReaderText = GoalGraphAccessibilityService.getScreenReaderTexts($scope.details);
            }

		var modalInstance;

        $scope.openGoalsModal = function () {
            FitnessService.openGoalsModal($scope.details).then(function (details) {
                goalService.save(details).then(function () {
                    setDetails(true);
                    location.reload();
                });
            }).finally(function () {
                focusService.focusElement(angular.element('button[ng-click="openGoalsModal()"]'));
                thisinit('root');
            });
        };

        $scope.openGoalsInfoModal = function () {
            var modalContent = {
                closeButtonText: 'No',
                actionButtonText: 'Yes',
                headerText: 'Welcome to VA FitHeart',
                bodyText: 'One of the most important parts of staying healthy is being active. You can get started by setting a weekly activity goal. Would you like to set a goal now?'
            };

            modalService.showModal({}, modalContent).then(function () {
                $scope.openGoalsModal();
            }, function () {
                focusService.focusMain();
                thisinit('-focus-');
            });
        };

		var openModal = function (template, controller, modalInfo) {
			modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/set-goals/set-goals_template.html',
				templateUrl: template,
				controller: controller,
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					}
				}
			});
		};

		var modalInfo = {value: null, dismissed: true, resendHash: []};
		$scope.$on('$stateChangeSuccess', function (event, toState, toParams, fromState, fromParams) {
			if (toState.name === 'main.auth.home' && fromState.name === '') {
				PatientFHIRService.getPatientContext().then(function (user) {
				});
			}
		});

        function loadUserDetails(user) {
            if (user) {
                $scope.userName = user.name[0].text;
                $scope.subject = 'Patient/' +user.id;
            }
        }
        if (!navigator.userAgent.match(/(iPad|iPhone|iPod)/g)) {
            angular.element($window).bind('resize.homeGraphResize', function() {
                $timeout(function() {
                    angular.forEach(Highcharts.charts, function (chart) {
                        if (chart) {
                            chart.setSize(chart.chartWidth, chart.chartHeight, false);
                        }
                    });
                });
            });

            $scope.$on('$destroy',function (){
                $scope.details = {};
                $(window).off('resize.homeGraphResize');
            });
        }

            $scope.$watch('$viewContentLoaded',
                function() {
                    $timeout(function() {
                        thisinit('-onload-');
                    },1);
                });


        function fetchGoals() {
            goalService.fetch().then(function () {
                setDetails();
            });
        }
       fetchGoals();
       thisinit('root');


                $scope.message = "Waiting 2000ms for update";

                setTimeout(function () {
                    thisinit('timeout call');
                    $scope.$apply(function () {
                        $scope.message = "Timeout called!";
                    });
                }, 2000);

	});
});